#include <windows.h>
#include <stdio.h>

#include "extern.h"



static INT32 dpcm_val_last;
static INT32 dpcm_code_last;


	
VOID Check_Limit( int lcv )
{
	static INT32 dpcm_count = 0;



	if( check_clip == FALSE )
		return;


	if( overflow == TRUE && dpcm_count == 0 )
	{
		overflow_count++;


		fprintf( fp_log, "Audio %d  (@%07X.001)  //  Overflow %d\n", wave_num, wave_num, overflow_count );
		fprintf( fp_log, "\n" );


		if( use16 == 0 )
			fprintf( fp_log, "[%08X - %08X, %08X] DPCM 8-bit overflow (L) = %04X\n",
				start, start + (header.bShift+2) + lcv, (header.bShift+2) + lcv, dpcm_l & 0xFF );

		else
		{
			fprintf( fp_log, "[%08X - %08X, %08X] DPCM 16-bit overflow (L) = %04X\n",
				start, start + (header.bShift+2) + lcv, (header.bShift+2) + lcv, dpcm_l & 0xFFFF );
			fprintf( fp_log, "\n" );

		

			fprintf( fp_log, "%04X", dpcm_val_last & 0xFFFF );


			if( buf[lcv] >= 0x80 )
				fprintf( fp_log, "  -" );

			else
				fprintf( fp_log, "  +" );


			fprintf( fp_log, "%04X", RawDpcm8( dpcm_code_last ) );
			fprintf( fp_log, "  %02X", dpcm_code_last );
			fprintf( fp_log, "  ----  \n" );



			fprintf( fp_log, "\n" );
		}




		dpcm_count = 9;
		newline = TRUE;
	}


	if( dpcm_count > 0 )
	{
		if( dpcm_count == 9-4 )
			fprintf( fp_log, "\n" );



		if( use16 == 0 )
		{
			fprintf( fp_log, "%02X", dpcm_l & 0xFF );


			if( buf[lcv] >= 0x08 )
				fprintf( fp_log, "  -" );

			else
				fprintf( fp_log, "  +" );



			if( bit4 == 0 )
			{
				fprintf( fp_log, "%02X", RawDpcm4( ( buf[lcv] >> 4 ) & 0x0F ) );
				fprintf( fp_log, "  %01X", ( buf[lcv] >> 4 ) & 0x0F );
			}

			else
			{
				fprintf( fp_log, "%02X", RawDpcm4( ( buf[lcv] >> 0 ) & 0x0F ) );
				fprintf( fp_log, "  %01X", ( buf[lcv] >> 0 ) & 0x0F );
			}



			fprintf( fp_log, "  ----  \n" );
		}

		else
		{
			fprintf( fp_log, "%04X", dpcm_l & 0xFFFF );


			if( buf[lcv] >= 0x80 )
				fprintf( fp_log, "  -" );

			else
				fprintf( fp_log, "  +" );


			fprintf( fp_log, "%04X", RawDpcm8( buf[lcv] ) );
			fprintf( fp_log, "  %02X", buf[ lcv ] );
			fprintf( fp_log, "  ----  \n" );
		}




		dpcm_count--;
		if( dpcm_count == 0 )
			fprintf( fp_log, "\n\n" );
	}
}



VOID Report_Limit()
{
	// dump mode only
	if( dump_file == TRUE && check_clip == FALSE && check_noise == FALSE )
	{
		fprintf( fp_log, "Audio %d  (@%07X.001)  %08X\n", wave_num, wave_num, start );
		fprintf( fp_log, "\n" );
	}



	if( newline )
		fprintf( fp_log, "\n\n\n" );


	fflush( fp_log );
	newline = FALSE;
}



VOID Decode16()
{
	INT32 dump_count;
	BOOL bad_clip;


	fix_clip_once = FALSE;
	bad_clip = FALSE;
	dump_count = -1;


	for( UINT32 lcv = 0; lcv < header.dwDataSize; lcv++ )
	{
		dpcm_val_last = dpcm_l;
		dpcm_code_last = buf[ lcv-1 ];




		dpcm_l = Decode8( dpcm_l, buf[lcv] & 0xFF );
		pcm[lcv] = dpcm_l;


		Check_Limit( lcv );
		Fix_Clip16( lcv );


		// ####################################################
		// ####################################################
		// ####################################################

		if( dump_count == 0 )
			break;

		dump_count--;



		// error check
		if( clip_error == TRUE || clip_error2 == TRUE )
		{
			fix_clip_once = FALSE;
			bad_clip = TRUE;

			dump_count = 9;
		}

		else if( fix_clip == TRUE )
		{
			fix_clip_once = TRUE;
			fix_clip = FALSE;
		}
	}


	if( bad_clip == TRUE )
		fix_clip_once = FALSE;
}



VOID Decode()
{
	if( use16 == 0 )
	{
		for( UINT32 lcv = 0; lcv < header.dwDataSize; lcv++ )
		{
			bit4 = 0;
			dpcm_l = Decode4( dpcm_l, ( buf[lcv] >> 4 ) & 0x0F );

			Check_Limit( lcv );


			// ##########################################
			// ##########################################
			// ##########################################

			bit4 = 1;
			dpcm_l = Decode4( dpcm_l, ( buf[lcv] >> 0 ) & 0x0F );

			Check_Limit( lcv );
		}
	}

	else
		Decode16();
}
