/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.EndpointHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdviceWithTasks {
    private static final Logger LOG = LoggerFactory.getLogger(AdviceWithTasks.class);

    private AdviceWithTasks() {
    }

    public static AdviceWithTask replaceByToString(RouteDefinition route, String toString, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doReplace(route, new MatchByToString(toString), replace, it);
    }

    public static AdviceWithTask replaceById(RouteDefinition route, String id, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doReplace(route, matchBy, replace, it);
    }

    public static AdviceWithTask replaceByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> replace, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doReplace(route, matchBy, replace, it);
    }

    private static AdviceWithTask doReplace(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> replace, final Iterator<ProcessorDefinition<?>> it) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getParentOutputs(output.getParent())) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    outputs.add(index + 1, replace);
                    Object old = outputs.remove(index);
                    LOG.info("AdviceWith (" + matchBy.getId() + ") : [" + old + "] --> replace [" + replace + "]");
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask removeByToString(RouteDefinition route, String toString, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doRemove(route, matchBy, it);
    }

    public static AdviceWithTask removeById(RouteDefinition route, String id, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doRemove(route, matchBy, it);
    }

    public static AdviceWithTask removeByType(RouteDefinition route, Class<?> type, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doRemove(route, matchBy, it);
    }

    private static AdviceWithTask doRemove(final RouteDefinition route, final MatchBy matchBy, final Iterator<ProcessorDefinition<?>> it) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getParentOutputs(output.getParent())) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    Object old = outputs.remove(index);
                    LOG.info("AdviceWith (" + matchBy.getId() + ") : [" + old + "] --> remove");
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask beforeByToString(RouteDefinition route, String toString, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doBefore(route, matchBy, before, it);
    }

    public static AdviceWithTask beforeById(RouteDefinition route, String id, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doBefore(route, matchBy, before, it);
    }

    public static AdviceWithTask beforeByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> before, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doBefore(route, matchBy, before, it);
    }

    private static AdviceWithTask doBefore(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> before, final Iterator<ProcessorDefinition<?>> it) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getParentOutputs(output.getParent())) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    Object existing = outputs.get(index);
                    outputs.add(index, before);
                    LOG.info("AdviceWith (" + matchBy.getId() + ") : [" + existing + "] --> before [" + before + "]");
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    public static AdviceWithTask afterByToString(RouteDefinition route, String toString, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByToString matchBy = new MatchByToString(toString);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doAfter(route, matchBy, after, it);
    }

    public static AdviceWithTask afterById(RouteDefinition route, String id, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchById matchBy = new MatchById(id);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doAfter(route, matchBy, after, it);
    }

    public static AdviceWithTask afterByType(RouteDefinition route, Class<?> type, ProcessorDefinition<?> after, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        MatchByType matchBy = new MatchByType(type);
        Iterator<ProcessorDefinition<?>> it = AdviceWithTasks.createMatchByIterator(route, matchBy, selectFirst, selectLast, selectFrom, selectTo, maxDeep);
        return AdviceWithTasks.doAfter(route, matchBy, after, it);
    }

    private static AdviceWithTask doAfter(final RouteDefinition route, final MatchBy matchBy, final ProcessorDefinition<?> after, final Iterator<ProcessorDefinition<?>> it) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                boolean match = false;
                while (it.hasNext()) {
                    int index;
                    List outputs;
                    ProcessorDefinition output = (ProcessorDefinition)it.next();
                    if (!matchBy.match(output) || (outputs = AdviceWithTasks.getParentOutputs(output.getParent())) == null || (index = outputs.indexOf(output)) == -1) continue;
                    match = true;
                    Object existing = outputs.get(index);
                    outputs.add(index + 1, after);
                    LOG.info("AdviceWith (" + matchBy.getId() + ") : [" + existing + "] --> after [" + after + "]");
                }
                if (!match) {
                    throw new IllegalArgumentException("There are no outputs which matches: " + matchBy.getId() + " in the route: " + route);
                }
            }
        };
    }

    private static List<ProcessorDefinition<?>> getParentOutputs(ProcessorDefinition<?> parent) {
        if (parent == null) {
            return null;
        }
        List<ProcessorDefinition<?>> outputs = parent.getOutputs();
        if (outputs.size() == 1 && outputs.get(0).isAbstract()) {
            outputs = outputs.get(0).getOutputs();
        }
        return outputs;
    }

    public static AdviceWithTask replaceFromWith(final RouteDefinition route, final String uri) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                FromDefinition from = route.getInputs().get(0);
                LOG.info("AdviceWith replace input from [{}] --> [{}]", from.getUriOrRef(), (Object)uri);
                from.setEndpoint(null);
                from.setRef(null);
                from.setUri(uri);
            }
        };
    }

    public static AdviceWithTask replaceFrom(final RouteDefinition route, final Endpoint endpoint) {
        return new AdviceWithTask(){

            @Override
            public void task() throws Exception {
                FromDefinition from = route.getInputs().get(0);
                LOG.info("AdviceWith replace input from [{}] --> [{}]", from.getUriOrRef(), (Object)endpoint.getEndpointUri());
                from.setRef(null);
                from.setUri(null);
                from.setEndpoint(endpoint);
            }
        };
    }

    private static Iterator<ProcessorDefinition<?>> createMatchByIterator(RouteDefinition route, MatchBy matchBy, boolean selectFirst, boolean selectLast, int selectFrom, int selectTo, int maxDeep) {
        ArrayList matched = new ArrayList();
        Iterator<ProcessorDefinition> itAll = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class, maxDeep);
        while (itAll.hasNext()) {
            ProcessorDefinition next = itAll.next();
            if (!matchBy.match(next)) continue;
            matched.add(next);
        }
        return AdviceWithTasks.createSelectorIterator(matched, selectFirst, selectLast, selectFrom, selectTo);
    }

    private static Iterator<ProcessorDefinition<?>> createSelectorIterator(final List<ProcessorDefinition<?>> list, final boolean selectFirst, final boolean selectLast, final int selectFrom, final int selectTo) {
        return new Iterator<ProcessorDefinition<?>>(){
            private int current;
            private boolean done;

            @Override
            public boolean hasNext() {
                if (list.isEmpty() || this.done) {
                    return false;
                }
                if (selectFirst) {
                    this.done = true;
                    this.current = 0;
                    return true;
                }
                if (selectLast) {
                    this.done = true;
                    this.current = list.size() - 1;
                    return true;
                }
                if (selectFrom >= 0 && selectTo >= 0) {
                    if (selectFrom >= list.size() || selectTo >= list.size()) {
                        return false;
                    }
                    if (this.current < selectFrom) {
                        this.current = selectFrom;
                    }
                    return this.current >= selectFrom && this.current <= selectTo;
                }
                return this.current < list.size();
            }

            @Override
            public ProcessorDefinition<?> next() {
                ProcessorDefinition answer = (ProcessorDefinition)list.get(this.current);
                ++this.current;
                return answer;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static final class MatchByType
    implements MatchBy {
        private final Class<?> type;

        private MatchByType(Class<?> type) {
            this.type = type;
        }

        @Override
        public String getId() {
            return this.type.getSimpleName();
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            return this.type.isAssignableFrom(processor.getClass());
        }
    }

    private static final class MatchByToString
    implements MatchBy {
        private final String toString;

        private MatchByToString(String toString) {
            this.toString = toString;
        }

        @Override
        public String getId() {
            return this.toString;
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            return EndpointHelper.matchPattern(processor.toString(), this.toString);
        }
    }

    private static final class MatchById
    implements MatchBy {
        private final String id;

        private MatchById(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean match(ProcessorDefinition<?> processor) {
            if (this.id.equals("*")) {
                return true;
            }
            return EndpointHelper.matchPattern(processor.getId(), this.id);
        }
    }

    private static interface MatchBy {
        public String getId();

        public boolean match(ProcessorDefinition<?> var1);
    }
}

