/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.frames.GoAwayFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;

public class GoAwayBodyParser
extends ControlFrameBodyParser {
    private final ControlFrameParser controlFrameParser;
    private State state = State.LAST_GOOD_STREAM_ID;
    private int cursor;
    private int lastStreamId;
    private int statusCode;

    public GoAwayBodyParser(ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block14: while (buffer.hasRemaining()) {
            switch (this.state) {
                case LAST_GOOD_STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.lastStreamId = buffer.getInt() & Integer.MAX_VALUE;
                        switch (this.controlFrameParser.getVersion()) {
                            case 2: {
                                this.onGoAway();
                                return true;
                            }
                            case 3: {
                                this.state = State.STATUS_CODE;
                                continue block14;
                            }
                        }
                        throw new IllegalStateException();
                    }
                    this.state = State.LAST_GOOD_STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block14;
                }
                case LAST_GOOD_STREAM_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.lastStreamId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block14;
                    this.lastStreamId &= Integer.MAX_VALUE;
                    switch (this.controlFrameParser.getVersion()) {
                        case 2: {
                            this.onGoAway();
                            return true;
                        }
                        case 3: {
                            this.state = State.STATUS_CODE;
                            continue block14;
                        }
                    }
                    throw new IllegalStateException();
                }
                case STATUS_CODE: {
                    if (buffer.remaining() >= 4) {
                        this.statusCode = buffer.getInt();
                        this.onGoAway();
                        return true;
                    }
                    this.state = State.STATUS_CODE_BYTES;
                    this.cursor = 4;
                    continue block14;
                }
                case STATUS_CODE_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.statusCode += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block14;
                    this.onGoAway();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onGoAway() {
        GoAwayFrame frame = new GoAwayFrame(this.controlFrameParser.getVersion(), this.lastStreamId, this.statusCode);
        this.controlFrameParser.onControlFrame(frame);
        this.reset();
    }

    private void reset() {
        this.state = State.LAST_GOOD_STREAM_ID;
        this.cursor = 0;
        this.lastStreamId = 0;
        this.statusCode = 0;
    }

    private static enum State {
        LAST_GOOD_STREAM_ID,
        LAST_GOOD_STREAM_ID_BYTES,
        STATUS_CODE,
        STATUS_CODE_BYTES;

    }
}

