/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.reflect;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.linkedin.util.collections.CompoundEnumeration;
import org.linkedin.util.reflect.NullClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderChain
extends ClassLoader {
    public static final String MODULE = ClassLoaderChain.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private final Collection<ClassLoader> _classLoaders;

    private ClassLoaderChain(Collection<ClassLoader> classLoaders) {
        this._classLoaders = classLoaders;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        for (ClassLoader classLoader : this._classLoaders) {
            url = classLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] enums = new Enumeration[this._classLoaders.size()];
        int i = 0;
        for (ClassLoader classLoader : this._classLoaders) {
            enums[i++] = classLoader.getResources(name);
        }
        return new CompoundEnumeration<URL>(enums);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        for (ClassLoader classLoader : this._classLoaders) {
            try {
                clazz = classLoader.loadClass(name);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("class not found in " + classLoader + "... moving to next one");
            }
        }
        throw new ClassNotFoundException(name);
    }

    public static ClassLoader createNewChain(ClassLoader ... classLoaders) {
        return ClassLoaderChain.createChain(Arrays.asList(classLoaders), true);
    }

    public static ClassLoader createChain(ClassLoader ... classLoaders) {
        return ClassLoaderChain.createChain(Arrays.asList(classLoaders), false);
    }

    public static ClassLoader createChain(List<ClassLoader> classLoaders) {
        return ClassLoaderChain.createChain(classLoaders, false);
    }

    public static ClassLoader createChain(List<ClassLoader> classLoaders, Boolean createNew) {
        ArrayList<ClassLoader> list = new ArrayList<ClassLoader>(classLoaders.size());
        for (ClassLoader classLoader : classLoaders) {
            if (classLoader == null || classLoader instanceof NullClassLoader) continue;
            if (classLoader instanceof ClassLoaderChain) {
                ClassLoaderChain classLoaderChain = (ClassLoaderChain)classLoader;
                list.addAll(classLoaderChain._classLoaders);
                continue;
            }
            list.add(classLoader);
        }
        if (list.size() == 0) {
            return NullClassLoader.instance();
        }
        ClassLoader previous = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ClassLoader next = (ClassLoader)iter.next();
            if (next.equals(previous)) {
                iter.remove();
            }
            previous = next;
        }
        if (list.size() == 1 && !createNew.booleanValue()) {
            return (ClassLoader)list.get(0);
        }
        return new ClassLoaderChain(list);
    }
}

