/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.AugmentedPropertyNameAwarePropertiesParser;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.Constants;
import org.springframework.util.PropertyPlaceholderHelper;

public class BridgePropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements PropertiesResolver,
AugmentedPropertyNameAwarePropertiesParser {
    private final Properties properties = new Properties();
    private PropertiesResolver resolver;
    private PropertiesParser parser;
    private String id;
    private PropertyPlaceholderHelper helper;
    private String configuredPlaceholderPrefix;
    private String configuredPlaceholderSuffix;
    private String configuredValueSeparator;
    private Boolean configuredIgnoreUnresolvablePlaceholders;
    private int systemPropertiesMode = 1;
    private Boolean ignoreResourceNotFound;

    public int getSystemPropertiesMode() {
        return this.systemPropertiesMode;
    }

    @Override
    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        this.properties.putAll((Map<?, ?>)props);
        this.helper = new PropertyPlaceholderHelper(this.configuredPlaceholderPrefix != null ? this.configuredPlaceholderPrefix : "${", this.configuredPlaceholderSuffix != null ? this.configuredPlaceholderSuffix : "}", this.configuredValueSeparator != null ? this.configuredValueSeparator : ":", this.configuredIgnoreUnresolvablePlaceholders != null ? this.configuredIgnoreUnresolvablePlaceholders : false);
    }

    @Override
    public void setBeanName(String beanName) {
        this.id = beanName;
        super.setBeanName(beanName);
    }

    @Override
    public void setSystemPropertiesModeName(String constantName) throws IllegalArgumentException {
        super.setSystemPropertiesModeName(constantName);
        Constants constants = new Constants(PropertyPlaceholderConfigurer.class);
        this.systemPropertiesMode = constants.asNumber(constantName).intValue();
    }

    @Override
    public void setSystemPropertiesMode(int systemPropertiesMode) {
        super.setSystemPropertiesMode(systemPropertiesMode);
        this.systemPropertiesMode = systemPropertiesMode;
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        super.setPlaceholderPrefix(placeholderPrefix);
        this.configuredPlaceholderPrefix = placeholderPrefix;
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        super.setPlaceholderSuffix(placeholderSuffix);
        this.configuredPlaceholderSuffix = placeholderSuffix;
    }

    @Override
    public void setValueSeparator(String valueSeparator) {
        super.setValueSeparator(valueSeparator);
        this.configuredValueSeparator = valueSeparator;
    }

    @Override
    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        super.setIgnoreUnresolvablePlaceholders(ignoreUnresolvablePlaceholders);
        this.configuredIgnoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    @Override
    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        super.setIgnoreResourceNotFound(ignoreResourceNotFound);
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    @Override
    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value = props.getProperty(placeholder);
        if (this.parser != null) {
            return this.parser.parseProperty(placeholder, value, props);
        }
        return value;
    }

    @Override
    public Properties resolveProperties(CamelContext context, boolean ignoreMissingLocation, String ... uri) throws Exception {
        Properties answer = new Properties();
        for (String u : uri) {
            Properties p;
            String ref = "ref:" + this.id;
            if (ref.equals(u)) {
                answer.putAll((Map<?, ?>)this.properties);
                continue;
            }
            if (this.resolver == null) continue;
            boolean flag = ignoreMissingLocation;
            if (this.ignoreResourceNotFound != null) {
                flag = this.ignoreResourceNotFound;
            }
            if ((p = this.resolver.resolveProperties(context, flag, u)) == null) continue;
            answer.putAll((Map<?, ?>)p);
        }
        return answer;
    }

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken, String propertyPrefix, String propertySuffix, boolean fallbackToUnaugmentedProperty) throws IllegalArgumentException {
        String answer = this.parser instanceof AugmentedPropertyNameAwarePropertiesParser ? ((AugmentedPropertyNameAwarePropertiesParser)this.parser).parseUri(text, properties, prefixToken, suffixToken, propertyPrefix, propertySuffix, fallbackToUnaugmentedProperty) : this.parser.parseUri(text, properties, prefixToken, suffixToken);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(text, properties);
        return answer;
    }

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
        String answer = this.parser.parseUri(text, properties, prefixToken, suffixToken);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(text, properties);
        return answer;
    }

    @Override
    public String parseProperty(String key, String value, Properties properties) {
        String answer = this.parser.parseProperty(key, value, properties);
        answer = answer != null ? this.springResolvePlaceholders(answer, properties) : this.springResolvePlaceholders(value, properties);
        return answer;
    }

    protected String springResolvePlaceholders(String text, Properties properties) {
        return this.helper.replacePlaceholders(text, new BridgePropertyPlaceholderResolver(properties));
    }

    public void setResolver(PropertiesResolver resolver) {
        this.resolver = resolver;
    }

    public void setParser(PropertiesParser parser) {
        this.parser = this.parser != null ? new BridgePropertiesParser(this.parser, parser) : parser;
    }

    private final class BridgePropertiesParser
    implements PropertiesParser {
        private final PropertiesParser delegate;
        private final PropertiesParser parser;

        private BridgePropertiesParser(PropertiesParser delegate, PropertiesParser parser) {
            this.delegate = delegate;
            this.parser = parser;
        }

        @Override
        public String parseUri(String text, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
            String answer = null;
            if (this.delegate != null) {
                answer = this.delegate.parseUri(text, properties, prefixToken, suffixToken);
            }
            if (answer != null) {
                text = answer;
            }
            return this.parser.parseUri(text, properties, prefixToken, suffixToken);
        }

        @Override
        public String parseProperty(String key, String value, Properties properties) {
            String answer = null;
            if (this.delegate != null) {
                answer = this.delegate.parseProperty(key, value, properties);
            }
            if (answer != null) {
                value = answer;
            }
            return this.parser.parseProperty(key, value, properties);
        }
    }

    private class BridgePropertyPlaceholderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Properties properties;

        public BridgePropertyPlaceholderResolver(Properties properties) {
            this.properties = properties;
        }

        @Override
        public String resolvePlaceholder(String placeholderName) {
            String propVal = null;
            if (BridgePropertyPlaceholderConfigurer.this.systemPropertiesMode == 2) {
                propVal = BridgePropertyPlaceholderConfigurer.this.resolveSystemProperty(placeholderName);
            }
            if (propVal == null) {
                propVal = (String)this.properties.get(placeholderName);
            }
            if (propVal == null && BridgePropertyPlaceholderConfigurer.this.systemPropertiesMode == 1) {
                propVal = BridgePropertyPlaceholderConfigurer.this.resolveSystemProperty(placeholderName);
            }
            return propVal;
        }
    }
}

