/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.handler.HandlerMethodSelector;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.util.ReflectionUtils;

public class AnnotationExceptionHandlerMethodResolver
extends AbstractExceptionHandlerMethodResolver {
    public static final ReflectionUtils.MethodFilter EXCEPTION_HANDLER_METHOD_FILTER = new ReflectionUtils.MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return AnnotationUtils.findAnnotation(method, MessageExceptionHandler.class) != null;
        }
    };

    public AnnotationExceptionHandlerMethodResolver(Class<?> handlerType) {
        super(AnnotationExceptionHandlerMethodResolver.initExceptionMappings(handlerType));
    }

    private static Map<Class<? extends Throwable>, Method> initExceptionMappings(Class<?> handlerType) {
        HashMap<Class<? extends Throwable>, Method> result = new HashMap<Class<? extends Throwable>, Method>();
        for (Method method : HandlerMethodSelector.selectMethods(handlerType, EXCEPTION_HANDLER_METHOD_FILTER)) {
            for (Class<? extends Throwable> exceptionType : AnnotationExceptionHandlerMethodResolver.getMappedExceptions(method)) {
                Method oldMethod = result.put(exceptionType, method);
                if (oldMethod == null || oldMethod.equals(method)) continue;
                throw new IllegalStateException("Ambiguous @ExceptionHandler method mapped for [" + exceptionType + "]: {" + oldMethod + ", " + method + "}.");
            }
        }
        return result;
    }

    private static List<Class<? extends Throwable>> getMappedExceptions(Method method) {
        ArrayList<Class<? extends Throwable>> result = new ArrayList<Class<? extends Throwable>>();
        MessageExceptionHandler annot = AnnotationUtils.findAnnotation(method, MessageExceptionHandler.class);
        result.addAll(Arrays.asList(annot.value()));
        if (result.isEmpty()) {
            result.addAll(AnnotationExceptionHandlerMethodResolver.getExceptionsFromMethodSignature(method));
        }
        return result;
    }
}

